﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace VIRP.AHOBPR.BO
{
    public class RegistrantHistory
    {

        Dictionary<DateRange, DateTime> occupationsByDateRange;
        SortedDictionary<DateTime, List<ServiceSpecificOccupation>> occupationsByDateTime;
        Dictionary<DateTime, PayGradeHistoryData> paymentDataByDateTime;
        Dictionary<DateRange, DateTime> paymentDataDateRange;

        public RegistrantHistory()
        {
            occupationsByDateTime = new SortedDictionary<DateTime, List<ServiceSpecificOccupation>>();
            occupationsByDateRange = new Dictionary<DateRange, DateTime>();
            paymentDataByDateTime = new Dictionary<DateTime, PayGradeHistoryData>();
            paymentDataDateRange = new Dictionary<DateRange, DateTime>();
        }
        public Dictionary<DateRange, string> PersonnelCategoryCodesByDateRange { get; set; }

        public Dictionary<DateRange, string> BranchesOfService { get; set; }

        public SortedDictionary<DateTime, List<ServiceSpecificOccupation>> OccupationsByDateTime
        {
            get
            {
                return occupationsByDateTime;
            }

            set
            {
                occupationsByDateTime = value;
                occupationsByDateRange = CreateOccupationsDateRange(value);
            }
        }

        public Dictionary<DateRange, DateTime> OccupationDateTimesByDateRange { get { return occupationsByDateRange; } }

        public Dictionary<DateTime, PayGradeHistoryData> PaymentDataByDateTime
        {
            get
            {
                return paymentDataByDateTime;
            }

            set
            {
                paymentDataByDateTime = value;
                paymentDataDateRange = CreatePaymentDataDateRange(value);

            }
        }
        public Dictionary<DateRange, DateTime> PaymentDateTimesByDateRange { get { return paymentDataDateRange; } }
        #region Methods
        public string GetPersonnelCategoryCode(DateRange value)
        {
            // Console.WriteLine($"PersonnelCategoryCodesByDateRange is null: {PersonnelCategoryCodesByDateRange == null}");
            var result = PersonnelCategoryCodesByDateRange.FirstOrDefault(e => e.Key.HasOverlap(value)).Value;
            // Console.WriteLine($"Result is: {result}");
            return result;
        }
        public PayGradeHistoryData GetPayHistoryData(DateRange deploymentDateRange)
        {
            //Console.WriteLine($"checking  GetPayHistoryData for {deploymentDateRange.Start} -> {deploymentDateRange.End}");
            var paymentDataKey = PaymentDateTimesByDateRange.FirstOrDefault(e => e.Key.HasOverlap(deploymentDateRange)).Value;
            //If not found it was set to default, which is DateTime.MinValue
            var payData = (paymentDataKey != DateTime.MinValue) ? PaymentDataByDateTime[paymentDataKey] : null;
            return payData;
        }
        public string GetBranchOfServiceCode(DateRange deploymentDateRange)
        {
            //Console.WriteLine($"checking BOS for {deploymentDateRange.Start} -> {deploymentDateRange.End}");
            return BranchesOfService.FirstOrDefault(e => e.Key.HasOverlap(deploymentDateRange)).Value;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        private Dictionary<DateRange, DateTime> CreateOccupationsDateRange(SortedDictionary<DateTime, List<ServiceSpecificOccupation>> value)
        {
            var dateTimesByDateRange = new Dictionary<DateRange, DateTime>();
            var keys = value.Keys.OrderBy(e => e.Date).ToList();
            for (int i = 0; i < keys.Count; i++)
            {
                var thisKey = value.Keys.ElementAt(i);
                if (i != keys.Count - 1)
                {
                    //Not at the end of the list. Make a daterange from the current element and the next element in the list (minus one day) 
                    var nextKeyMinusOneDay = keys.ElementAt(i + 1).AddDays(-1);
                    dateTimesByDateRange.Add(new DateRange(thisKey, nextKeyMinusOneDay), thisKey);
                }
                else
                {
                    //At the end of the list. Make a new daterange from last element up until now
                    dateTimesByDateRange.Add(new DateRange(thisKey, DateTime.Now), thisKey);
                }
            }
            return dateTimesByDateRange;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        Dictionary<DateRange, DateTime> CreatePaymentDataDateRange(Dictionary<DateTime, PayGradeHistoryData> value)
        {
            var dateTimesByDateRange = new Dictionary<DateRange, DateTime>();

            var keys = value.Keys.OrderBy(e => e.Date).ToList();
            //foreach (var key in keys)
            //{
            //    Trace.Write(key.ToShortDateString() + " -> ");
            //}
            for (int i = 0; i < keys.Count; i++)
            {
                var thisKey = keys.ElementAt(i);
                if (i != keys.Count - 1)
                {
                    //Since we're not at the end of the list. Make a daterange from the current element and the next element in the list (minus one day) 
                    var nextKeyMinusOneDay = keys.ElementAt(i + 1).AddDays(-1);
                    var tempRange = new DateRange(thisKey, nextKeyMinusOneDay);
                    dateTimesByDateRange.Add(tempRange, thisKey);
                }
                else
                {
                    //At the end of the list. Make a new daterange from last element up until now
                    dateTimesByDateRange.Add(new DateRange(thisKey, DateTime.Now), thisKey);
                }
            }
            return dateTimesByDateRange;
        }
        #endregion
    }
}
